<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cfg=".">
   <xsl:output method="text"/>
   <!--##############  PARAMETER  ####################-->
   <xsl:param name="Group" select="'1'"/>
   <xsl:param name="Node" select="'1'"/>
   <xsl:param name="Slot" select="1"/>
   <!--##############  VARIABLES  ####################-->
   <xsl:variable name="NEWLINE" select="string('&#13;&#10;')"/>
   <xsl:variable name="DELIMITER" select="','"/>
   <xsl:variable name="Meldebereich" select="'255'"/>
   <!--##############  BEGIN Namspace cfg   ####################-->
   <cfg:Stylesheet mode="TRANSFORM" version="$Revision: 1.4 $" versionscope="ALL_FILES" output_suffix="_test.txt"/>
   <cfg:Description lang="EN">Generate configuration text-file for SenSim. Parameters (defaults): Group (1), Node(1),Slot(1) </cfg:Description>
   <cfg:Texts>
  </cfg:Texts>
   <!--##############  END Namspace cfg   ####################-->
   <xsl:template match="/">
      <xsl:apply-templates select="//HEADER | //LSN300_MODULE | //LSN1500_MODULE | //LSN_BUS"/>
   </xsl:template>
   <!--  ##HEADER -->
   <xsl:template match="/*/HEADER">
      <xsl:text>##HEADER</xsl:text>
      <xsl:value-of select="$NEWLINE"/>
      <xsl:text>FPA5000,</xsl:text>
      <xsl:value-of select="filename"/>
      <xsl:value-of select="$DELIMITER"/>
      <xsl:choose>
         <xsl:when test="//NODE[netGroup=$Group and netNode=$Node]">
            <xsl:value-of select="//NODE[netGroup=$Group and netNode=$Node]/@rpsDisplayName"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:text>(unknown node: </xsl:text>
            <xsl:value-of select="$Group"/>
            <xsl:text>.</xsl:text>
            <xsl:value-of select="$Node"/>
            <xsl:text>)</xsl:text>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="$NEWLINE"/>
      <xsl:value-of select="$NEWLINE"/>
   </xsl:template>
   <!--  ##Module -->
   <xsl:template match="LSN300_MODULE | LSN1500_MODULE">
      <xsl:if test="slot = $Slot and ancestor::NODE/netGroup=$Group and ancestor::NODE/netNode=$Node">
         <xsl:variable name="Mode">
            <xsl:choose>
               <xsl:when test="mode = 'LSN_CLASSIC'">Classic</xsl:when>
               <xsl:when test="mode = 'LSN_EXTENDED'">Improved</xsl:when>
               <xsl:when test="mode = 'LSN_TTAP'">TTap</xsl:when>
               <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <xsl:variable name="Topology">
            <xsl:choose>
               <xsl:when test="topology = 'TOPOT_LOOP'">Loop</xsl:when>
               <xsl:when test="topology = 'TOPOT_STUB'">Stub</xsl:when>
               <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
         <xsl:text>##Module</xsl:text>
         <xsl:value-of select="$NEWLINE"/>
         <xsl:value-of select="name()"/>
         <xsl:value-of select="$DELIMITER"/>
         <xsl:value-of select="$Mode"/>
         <xsl:value-of select="$DELIMITER"/>
         <xsl:value-of select="$Topology"/>
         <xsl:value-of select="$DELIMITER"/>
         <xsl:value-of select="lastElement"/>
         <xsl:value-of select="$NEWLINE"/>
         <xsl:value-of select="$NEWLINE"/>
      </xsl:if>
   </xsl:template>
   <!--  ##Daten -->
   <xsl:template match="LSN_BUS">
      <xsl:if test="../slot = $Slot and ancestor::NODE/netGroup=$Group and ancestor::NODE/netNode=$Node">
      <xsl:if test="port ='1'">
         <xsl:text>##DATA_NEW</xsl:text>
         <xsl:value-of select="$NEWLINE"/>
         </xsl:if>
         <xsl:for-each select="*">
            <xsl:if test="name() != 'siType' and name() != 'port' and name() != 'label' and name() != 'siNumber'">
               <xsl:choose>
                  <xsl:when test="name() = 'NAK100'">
                     <xsl:call-template name="WriteLine"/>
                     <xsl:for-each select="./LSN_BUS_NAK100/*">
                        <xsl:if test="name() != 'siType' and name() != 'port' and name() != 'label' and name() != 'siNumber'">
                           <xsl:call-template name="WriteLine"/>
                        </xsl:if>
                     </xsl:for-each>
                  </xsl:when>
                  <xsl:when test="name() = 'FK100'">
                     <xsl:call-template name="WriteLine"/>
                     <xsl:for-each select="./LSN_BUS_FK100/*">
                        <xsl:if test="name() != 'siType' and name() != 'port' and name() != 'label' and name() != 'siNumber'">
                           <xsl:call-template name="WriteLine"/>
                        </xsl:if>
                     </xsl:for-each>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:call-template name="WriteLine"/>
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:if>
         </xsl:for-each>
      </xsl:if>
   </xsl:template>
   <xsl:template name="WriteLine">
      <xsl:variable name="ElementName" select="name()"/>
      <xsl:value-of select="comAdr"/>
      <xsl:value-of select="$DELIMITER"/>
      <xsl:value-of select="backPointer"/>
      <xsl:value-of select="$DELIMITER"/>
      <xsl:choose>
         <xsl:when test="branch">
            <xsl:value-of select="branch"/>
         </xsl:when>
         <xsl:otherwise>0</xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="$DELIMITER"/>
      <xsl:value-of select="document('LSN_Elements.xml')/LSNDevices/LSN_DEVICE[elementName = $ElementName]/officialName"/>
      <xsl:value-of select="$DELIMITER"/>
      <xsl:value-of select="lsnTypeID"/>
      <xsl:value-of select="$DELIMITER"/>
      <xsl:value-of select="lsnSubtype"/>
      <xsl:value-of select="$DELIMITER"/>
      <xsl:choose>
         <xsl:when test="siNumber">
            <xsl:value-of select="siNumber"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select="*/siNumber"/>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:text>-</xsl:text>
      <xsl:choose>
         <xsl:when test="subNumber">
            <xsl:value-of select="subNumber"/>
         </xsl:when>
         <xsl:otherwise>
            <xsl:choose>
               <xsl:when test="*/subNumber">
                  <xsl:value-of select="*/subNumber"/>
               </xsl:when>
               <xsl:otherwise>0</xsl:otherwise>
            </xsl:choose>
         </xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="$DELIMITER"/>
      <xsl:value-of select="$Meldebereich"/>
      <xsl:value-of select="$DELIMITER"/>
      <xsl:value-of select="label"/>
      <xsl:value-of select="$NEWLINE"/>
   </xsl:template>
</xsl:stylesheet>
